﻿#include <stdio.h>
#include <sal/main.h>
#include <cppuhelper/bootstrap.hxx>
#include <com/sun/star/bridge/XUnoUrlResolver.hpp>
#include <com/sun/star/frame/Desktop.hpp>
#include <com/sun/star/frame/XComponentLoader.hpp>
#include <com/sun/star/lang/XMultiComponentFactory.hpp>
#include <com/sun/star/frame/XStorable.hpp>
using namespace com::sun::star::beans;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::frame;
using ::rtl::OUString;
using ::rtl::OUStringToOString;

SAL_IMPLEMENT_MAIN_WITH_ARGS(argc, argv)
{
    try
    {
        // get the remote office component context
        Reference< XComponentContext > xContext(::cppu::bootstrap());
        if (!xContext.is())
        {
            fprintf(stderr, "no component context!\n");
            return 1;
        }

        // get the remote office service manager
        Reference< XMultiComponentFactory > xServiceManager(
            xContext->getServiceManager());
        if (!xServiceManager.is())
        {
            fprintf(stderr, "no service manager!\n");
            return 1;
        }

        // get an instance of the remote office desktop UNO service
        // and query the XComponentLoader interface
        Reference < XDesktop2 > xComponentLoader = Desktop::create(xContext);

        // create a new writer document
        Sequence<PropertyValue> props(1);
        PropertyValue prop;
        prop.Name = "Hidden";
        prop.Value = Any(true);
        props[0] = prop;
        Reference< XComponent > xComponent(xComponentLoader->loadComponentFromURL(
            OUString("private:factory/swriter"), "_blank", 0, props));
        if (!xComponent.is())
        {
            fprintf(stderr, "creating writer document failed!\n");
            return 1;
        }

        // get the XStorable interface for the current document
        Reference< XStorable > xStorable(xComponent, UNO_QUERY);
        if (!xStorable.is())
        {
            fprintf(stderr, "getting XStorable interface failed!\n");
            return 1;
        }

        // specify the URL to save the document to
        OUString saveUrl("file:////home/test/test.odt");

        // create a PropertyValue sequence to pass arguments to storeAsURL()
        Sequence<PropertyValue> properties(1);
        PropertyValue property;
        property.Name = "FilterName";
        property.Value <<= OUString("writer8");
        properties[0] = property;

        // save the document
        xStorable->storeAsURL(saveUrl, properties);

        // close the document
        xComponent->dispose();
    }
    catch (::cppu::BootstrapException& e)
    {
        fprintf(stderr, "caught BootstrapException: %s\n",
            OUStringToOString(e.getMessage(), RTL_TEXTENCODING_ASCII_US).getStr());
        return 1;
    }
    catch (Exception& e)
    {
        fprintf(stderr, "caught UNO exception: %s\n",
            OUStringToOString(e.Message, RTL_TEXTENCODING_ASCII_US).getStr());
        return 1;
    }

    return 0;
}
