#include <stdio.h>
#include <sal/main.h>
#include <cppuhelper/bootstrap.hxx>
#include <com/sun/star/frame/Desktop.hpp>
#include <com/sun/star/frame/XComponentLoader.hpp>
#include <com/sun/star/lang/XMultiComponentFactory.hpp>
#include <com/sun/star/frame/XStorable.hpp>
#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/text/XTextDocument.hpp>

using namespace com::sun::star::text;
using namespace com::sun::star::awt;
using namespace com::sun::star::beans;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::frame;
using ::rtl::OUString;
using ::rtl::OUStringToOString;

SAL_IMPLEMENT_MAIN_WITH_ARGS(argc, argv)
{
    try
    {
        //  получаем контекст компонентов офиса
        Reference< XComponentContext > xContext(::cppu::bootstrap());
        if (!xContext.is())
        {
            fprintf(stderr, "no component context!\n");
            return 1;
        }

        // получаем сервис-менеджер
        Reference< XMultiComponentFactory > xServiceManager(
            xContext->getServiceManager());
        if (!xServiceManager.is())
        {
            fprintf(stderr, "no service manager!\n");
            return 1;
        }

        // получаем экземпляр сервиса UNO Desktop
        // получаем интерфейс XComponentLoader


        Reference<XComponentLoader> xLoader(xContext->getServiceManager()->createInstanceWithContext(
            "com.sun.star.frame.Desktop", xContext), UNO_QUERY);


        // создаем новый документ или загружаем существующий
        Sequence<PropertyValue> props(2);
        PropertyValue prop[2];
        prop[0].Name = "FliterName";
        prop[0].Value <<= OUString("writer8");
        prop[1].Name = "Overwrite";
        prop[1].Value <<= Any(true);
        props[0] = prop[0];
        props[1] = prop[1];
        Reference<com::sun::star::uno::XInterface> xComponent = xLoader->loadComponentFromURL(
            "file:////home/test/test.odt", "_blank", 0, props);



        Reference<XTextDocument> xDoc(xComponent, UNO_QUERY);
        // Получаем интерфейс XText
        Reference<XText> xText = xDoc->getText();

        // Создаем объект интерфейса XTextRange, указывающий на начало документа
        Reference<XTextRange> xStart = xText->getStart();

        // Создаем объект интерфейса XTextRange, указывающий на конец документа
        Reference<XTextRange> xEnd = xText->getEnd();

        // Создаем объект интерфейса XTextCursor
        Reference<XTextCursor> xCursor = xText->createTextCursor();

        // Устанавливаем позицию курсора в начало документа
        xCursor->gotoRange(xStart, false);

        // Выделяем весь текст в документе
        xCursor->gotoRange(xEnd, true);

        // Удаляем выделенный текст
        xCursor->setString("");



        // получаем интерфейс XStorable для текущего документа
        Reference< XStorable > xStorable(xComponent, UNO_QUERY);
        if (!xStorable.is())
        {
            fprintf(stderr, "getting XStorable interface failed!\n");
            return 1;
        }

        // задаем URL для сохранения документа
        OUString saveUrl("file:////home/test/test.odt");

        // сохраняем документ
        xStorable->storeAsURL(saveUrl, props);

        // закрываем документ

       //xDoc->dispose();
    }
    catch (::cppu::BootstrapException& e)
    {
        fprintf(stderr, "caught BootstrapException: %s\n",
            OUStringToOString(e.getMessage(), RTL_TEXTENCODING_ASCII_US).getStr());
        return 1;
    }
    catch (Exception& e)
    {
        fprintf(stderr, "caught UNO exception: %s\n",
            OUStringToOString(e.Message, RTL_TEXTENCODING_ASCII_US).getStr());
        return 1;
    }

    return 0;
}
